Pipe = class()

function Pipe:created(width, height)
    self.width = width
    self.height = height
    self.entity.body2d:box(width, height)
    self.colors = {
        strokeC = color(86, 158, 82),
    fillC = color(111, 175, 134)}
end

function Pipe:draw()
    style.push().fill(self.colors.fillC).rectMode(CENTER).strokeWidth(0.3 * scene.main.pixelsPerUnit).stroke(self.colors.strokeC)
    lineWidth = style.strokeWidth()
    rect(0, 0, self.width- (lineWidth ) / scene.main.pixelsPerUnit, self.height- (lineWidth) / scene.main.pixelsPerUnit)
    style.pop()
    
end

function Pipe:playDestory()
    tween(self.colors):to{fillC = color(111, 175, 134,0), strokeC = color(86, 158, 82, 0)}:time(0.25)
end
